package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.TareaOS3;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TareaOS3Service generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

public interface TareaOS3Service {

	/**
	 * Inserts a single row in the TareaOS3 table.
	 * 
	 *  tareaOs3
	 *            TareaOS3
	 *  TareaOS3
	 *
	 * @param tareaOs3 the tarea os 3
	 * @return the tarea OS 3
	 */
	TareaOS3 add(TareaOS3 tareaOs3);

	/**
	 * Updates a single row in the TareaOS3 table.
	 * 
	 *  tareaOs3
	 *            TareaOS3
	 *  TareaOS3
	 *
	 * @param tareaOs3 the tarea os 3
	 * @return the tarea OS 3
	 */
	TareaOS3 update(TareaOS3 tareaOs3);

	/**
	 * Updates a single row in the TareaOS3 table.
	 * 
	 *  tareaOs3
	 *            TareaOS3
	 *  TareaOS3
	 *
	 * @param tareaOs3 the tarea os 3
	 * @return the tarea OS 3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TareaOS3 updateFilled(TareaOS3 tareaOs3);

	/**
	 * Finds a single row in the TareaOS3 table.
	 * 
	 *  tareaOs3
	 *            TareaOS3
	 *  TareaOS3
	 *
	 * @param tareaOs3 the tarea os 3
	 * @return the tarea OS 3
	 */
	TareaOS3 find(TareaOS3 tareaOs3);

	/**
	 * Finds a single row in the TareaOS3 table.
	 * 
	 *  tareaOs3
	 *            TareaOS3
	 *  TareaOS3
	 *
	 * @param tareaOs3 the tarea os 3
	 * @return the tarea OS 3
	 */
	public TareaOS3 findTareaTramite(TareaOS3 tareaOs3);

	/**
	 * Finds a single row in the TareaOS3 table.
	 * 
	 *  mailboxTaskId
	 *            String
	 *  TareaOS3
	 *
	 * @param mailboxTaskId the mailbox task id
	 * @return the tarea OS 3
	 */
	public TareaOS3 findByMailboxTaskId(String mailboxTaskId);

	/**
	 * Deletes a single row in the TareaOS3 table.
	 * 
	 *  tareaOs3
	 *            TareaOS3
	 *
	 * @param tareaOs3 the tarea os 3
	 */
	void remove(TareaOS3 tareaOs3);

	/**
	 * Finds a list of rows in the TareaOS3 table.
	 * 
	 *  tareaOs3
	 *            TareaOS3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<TareaOS3>
	 *
	 * @param tareaOs3 the tarea os 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	List<TareaOS3> findAll(TareaOS3 tareaOs3,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds a list of rows in the TareaOS3 table.
	 * 
	 *  tareaOs3
	 *            TareaOS3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<TareaOS3>
	 *
	 * @param tareaOs3 the tarea os 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<TareaOS3> findAllTareatramite(TareaOS3 tareaOs3,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the TareaOS3 table using like.
	 * 
	 *  tareaOs3
	 *            TareaOS3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TareaOS3>
	 *
	 * @param tareaOs3 the tarea os 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TareaOS3> findAllLike(TareaOS3 tareaOs3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the TareaOS3 table.
	 * 
	 *  filterTareaOS3
	 *            TareaOS3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<TareaOS3>
	 *
	 * @param filterTareaOS3 the filter tarea OS 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<TareaOS3> filter(TareaOS3 filterTareaOS3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the TareaOS3 table.
	 * 
	 *  filterTareaOS3
	 *            TareaOS3
	 *  searchTareaOS3
	 *            TareaOS3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<TareaOS3>>
	 *
	 * @param filterTareaOS3 the filter tarea OS 3
	 * @param searchTareaOS3 the search tarea OS 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TableRowDto<TareaOS3>> search(TareaOS3 filterTareaOS3,
			TareaOS3 searchTareaOS3, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Reorder the selection made in TareaOS3 table.
	 * 
	 *  filterTareaOS3
	 *            TareaOS3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterTareaOS3 the filter tarea OS 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	Object reorderSelection(TareaOS3 filterTareaOS3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

}
